const express = require("express");
const router = express.Router();

const { verifyToken } = require("../config/jwtHelper")
const { signup, verifyOTP, resendOTP, login, authenticate, changePassword, ForgotPassword, NewPassword, getSites, updateCompanyDetails, getUser, getAllUsers, contactUs, getAllUnpaidScripts, getAllPaidScripts, getUsersData, getAllData, sendReminder, sendSmsReminder, sendWhatsAppMsgReminder, addNewUser, sendBulkMsgs, getAllPausedScripts, changeUserDetails, getAllFreeScripts, getAltTextSites } = require("../controllers/user.controller");
const { sendScript, isValidScript, activateScript, deActivateScript, cancelSubscription, addClientSite, addAdminSite, addAdminSiteAndClient, activateFreeScript, deActivateFreeScript } = require("../controllers/script.controller")
const { plans, createSession } = require("../controllers/payment.controller");
const { addEvents, getEvents, getBlobData } = require("../controllers/events.controller");
const { addAltTexts, getAltTexts } = require("../controllers/image-analysis.controller");

// User Controller Client Side
router.post('/signup',signup);
router.post('/verifyOTP',verifyOTP);
router.post('/resendOTP',resendOTP);
router.post('/login',verifyToken,login);
router.post('/authenticate',authenticate);
router.post('/changePassword',verifyToken, changePassword);
router.post('/forgot-password', ForgotPassword);
router.post('/new-password', NewPassword);
router.get('/getUser/:email',verifyToken, getUser);
router.get('/getSites/:email',verifyToken, getSites);
router.post('/updateCompanyDetails',verifyToken, updateCompanyDetails);
router.get('/getAllUsers',verifyToken, getAllUsers);
router.post('/contactUs',contactUs);
router.post('/addNewUser',addNewUser);
router.post('/sendBulkMsgs',sendBulkMsgs);
router.post('/changeUserDetails/:email', verifyToken, changeUserDetails)
router.get('/getAltTextSites/:userId',verifyToken, getAltTextSites);

// Script Controller Client Side
router.post('/addClientSite', verifyToken, addClientSite);
router.post('/getScript', verifyToken, sendScript);
router.post('/isValidScript',isValidScript);

// Payment Controller Client Side
router.get('/getPlans', verifyToken, plans);
router.post('/createSession', verifyToken, createSession);

// User Controller Admin Side
router.get('/getAllUnpaidScripts', verifyToken, getAllUnpaidScripts);
router.get('/getAllPaidScripts', verifyToken, getAllPaidScripts);
router.get('/getAllPausedScripts',verifyToken,getAllPausedScripts);
router.get('/getUsersData', verifyToken, getUsersData);
router.get('/getAllData',verifyToken,  getAllData);
router.post('/sendReminder', verifyToken, sendReminder);
router.post('/sendSmsReminder', sendSmsReminder);
router.post('/sendWhatsAppMsgReminder', sendWhatsAppMsgReminder);
router.get('/getAllFreeScripts',verifyToken,  getAllFreeScripts);

// Script Controller Admin Side
router.post('/activateScript', verifyToken, activateScript);
router.post('/deActivateScript', verifyToken, deActivateScript);
router.post('/cancelSubscription', verifyToken, cancelSubscription);
router.post('/activateFreeScript', verifyToken, activateFreeScript);
router.post('/deActivateFreeScript', verifyToken, deActivateFreeScript);
router.post('/addAdminSite',verifyToken,  addAdminSite);
router.post('/addAdminSiteAndClient',verifyToken, addAdminSiteAndClient);

// Events Controller
router.post('/saveEvents', addEvents);
router.post('/getEvents', getEvents);
router.get('/getBlobData/:blobName',verifyToken, getBlobData);

// Image Analysis Controller
router.post('/saveAltTexts', addAltTexts);
router.post('/getAltTexts', getAltTexts);

module.exports = router;