const Users = require("../models/user");
const { generatePaypalToken } = require("../config/paypalHelper");
const {
  FEATURES,
  PAYMENT_METHODS,
  USER_ROLES,
} = require("../constants/app.constants");
const axios = require("axios");

async function adminAddUser (name, email, password, phoneNo,feature) {
    return new Promise ((resolve,reject) => {
    try {
        // Check if email already exist
           Users.findOne({ Email: email }).exec((err, user) => {
            if (user) {
                reject({error:"This email is already in use."})
            }
            const reqFeature = feature?.toUpperCase();
            if (!FEATURES.includes(reqFeature)) {
                reject({error:`Requested feature '${reqFeature}' not available`})
            }
            // Creating new user
            let newuser = new Users({
                Name: name,
                Email: email,
                Password: password,
                isVerified: true,
                PhoneNo: phoneNo,
            })
            
            // Saving new user
            newuser.save(async(err,data) => {
                if (err) {
                    console.log(err)
                    reject({error:"Error saving new user"});
                }
                resolve("User added successfully")
            })
        });
    } catch(e) {
        console.log('Error in User Create : ',e);
        reject({error:e});
    }
})

}
exports.addAdminSiteAndClient = async (req,res) => {
  const { email, domain, language, platform, feature, name, password, phoneNo  } = req.body;
    adminAddUser(name,email,password,phoneNo,feature)
       .then(()=> {
           return addSite(email, domain, language, platform, feature, USER_ROLES.Admin)
       })
       .then(data => {
        console.log(data, 'script')
        return res.status(200).send(data);
       })
       .catch((error)=>{
        res.status(400).json(error)
       })

}
exports.addAdminSite = async (req, res) => {
  const { email, domain, language, platform, feature  } = req.body;
    
  await addSite(email, domain, language, platform, feature, USER_ROLES.Admin)
    .then((data) => {
      return res.status(200).send(data);
    })
    .catch((error) => {
      console.log("Err ", error);
      return res.status(400).json(error);
    });

};

exports.addClientSite = async (req, res) => {
  const { email, domain, language, platform, feature } = req.body;
//   try {
    await addSite(email, domain, language, platform, feature)
      .then((data) => {
        return res.status(200).send(data);
      })
      .catch((error) => {
        console.log("err", error);
        return res.status(400).json(error);
      });
//   } catch (e) {
//     console.log(e);
//     res.status(400).send(e);
//   }
};

const addSite = (
  email,
  domain,
  language,
  platform,
  feature,
  userType = USER_ROLES.Client
) => {
  return new Promise((resolve, reject) => {
    try {
      Users.findOne({ Email: email }, { Password: 0 }, async (err, user) => {
        if (err || !user) {
          reject({ error: "Error finding user" });
        }
        if (!feature) {
          reject({ error: "Please specify feature" });
        }
        const reqFeature = feature?.toUpperCase();
        if (!FEATURES.includes(reqFeature)) {
          reject({ error: "Requested feature not available" });
        }

        let isDomainExist = await user.Sites.find(
          (site) => site.domainName === domain
        );

        if (typeof isDomainExist !== "undefined") {
          if (isDomainExist.Feature.includes(reqFeature)) {
            reject({
              error: `A subscription for ${reqFeature} already exist! Try using another`,
            });
          } else {
            isDomainExist.subscriptionId.push(
              userType === USER_ROLES.Admin
                ? process.env.ADMIN_SUBSCRIPTION_ID
                : ""
            );
            isDomainExist.paymentMethod.push(process.env.PAYMENT_METHOD_EMPTY);
            isDomainExist.isActive.push(
              userType === USER_ROLES.Admin ? true : false
            );
            isDomainExist.Feature.push(reqFeature);
          }
        } else {
          site = {
            domainName: domain,
            Language: language,
            Platform: platform,
            Script: [],
            subscriptionId: [
              userType === USER_ROLES.Admin
                ? process.env.ADMIN_SUBSCRIPTION_ID
                : "",
            ],
            paymentMethod: [process.env.PAYMENT_METHOD_EMPTY],
            isActive: [userType === USER_ROLES.Admin ? true : false],
            Feature: [reqFeature],
          };
          user.Sites.push(site);
        }
        user
          .save()
          .then(async (data) => {
            await scriptHandler(data._id, domain, reqFeature)
              .then((data) => {
                resolve(data);
              })
              .catch((error) => {
                console.log("Err ", error);
                reject(error);
              });
          })
          .catch((err) => {
            console.log("Error ", err);
            reject({ error: err });
          });
      });
    } catch (e) {
      console.log(e);
      res.status(400).send(e);
    }
  });
};

const scriptHandler = (userId, domain, reqFeature) => {
  return new Promise((resolve, reject) => {
    Users.findOne({ _id: userId }, async (err, user) => {
      if (err) {
        reject({ error: "Error finding users." });
      } else if (!user) {
        reject({ error: "User record not found." });
      }
      let result = user.Sites.find((site) => site.domainName === domain);
      let index = result.Feature.indexOf(reqFeature);

      const srcScript = await getSrcFile(reqFeature);
      const script = `<script> window.interdeal = { "sitekey": "${result._id}", "userId": "${userId}","feature": "${reqFeature}", "Menulang": "EN", "domains": { "js": "https://cdn.equalweb.com/", "acc": "https://access.equalweb.com/" }, "btnStyle": { "vPosition": [ "80%", null ], "scale": [ "0.8", "0.8" ], "icon": { "type": 7, "shape": "semicircle", "outline": false } } }; (function(doc, head, body){ var coreCall = doc.createElement('script'); coreCall.src = '${srcScript}'; coreCall.defer = true;  coreCall.setAttribute('data-cfasync', true ); body? body.appendChild(coreCall) : head.appendChild(coreCall); })(document, document.head, document.body); </script>`;

      result.Script[index] = script;
      await user
        .save()
        .then((data) => {
          console.log("Script ", script);
          resolve(script);
        })
        .catch((err) => {
          console.log("Error in script handler ", err);
          reject({ error: err.message });
        });
    });
  });
};

const getSrcFile = async (reqFeature) => {
  switch (reqFeature) {
    case "PLUGIN_ANALYTICS_COMBO":
      return "https://scripttest.ngf.co.il/script.js";
      break;
    case "ALT_TEXT":
      return "https://scripttest.ngf.co.il/imagetag.js";
      break;
    case "ALL_FEATURES":
      return "https://scripttest.ngf.co.il/allFeatures.js";
      break;
    default:
      return null;
  }
};

exports.sendScript = (req, res) => {
  try {
    const { email, domainName, feature } = req.body;
    Users.findOne({ Email: email }, async (err, user) => {
      if (err || !user) {
        return res.status(400).json({ error: "Error finding user" });
      } else {
        if (!FEATURES.includes(feature)) {
          return res.status(400).json({
            error: `Requested feature '${feature}' not available.`,
          });
        }

        const domain = await user?.Sites?.find(
          (site) => site.domainName === domainName
        );

        if (domain) {
          let index = domain?.Feature?.indexOf(feature);

          return res.status(200).json({ script: domain?.Script[index] });
        } else {
          return res.status(400).json({
            error: `Sorry! No script available for this domain: ${domainName} & feature '${feature}'.`,
          });
        }

        //let currentTime = new Date().getTime()/1000;

        // if((domain[0].trialEnd[index]-currentTime)/86400 < 0 && domain[0].stripeSubscriptionId[index] === '') {

        //     domain[0].trialEnd[index] !== 0 ? domain[0].trialEnd[index] = 0 : domain[0].trialEnd[index]
        //     domain[0].isActive[index] ? domain[0].isActive[index] = false : domain[0].isActive[index]

        //     user.save().then(()=>{
        //         res.status(400).send({isActive: false})
        //     })
        // }
        // else if((domain[0].isActive[index] && domain[0].stripeSubscriptionId[index] === '' && domain[0].trialEnd[index]-currentTime)/86400 > 0) {
        //     res.status(200).send({isActive: true, script: domain[0].Script[index]})
        // }
        // else if(domain[0].stripeSubscriptionId[index] !== '' && domain[0].isActive[index]) {
        //     res.status(200).send({isActive: true, script: domain[0].Script[index]})
        // }
        // else if(!domain[0].isActive[index]){
        //     res.status(400).send({isActive: false})
        // }
        // else {
        //     res.status(400).send({isActive: false})
        // }
      }
    });
  } catch (e) {
    return res.status(404).json({ error: "Error getting script" });
  }
};

exports.isValidScript = (req, res) => {
  const { domainName, userId, siteKey, feature } = req.body;
  let script = `let outerCircle = document.createElement('div'); outerCircle.classList.add('script-circle'); outerCircle.style.zIndex='9999'; outerCircle.style.backgroundColor = 'red'; outerCircle.style.position = 'fixed'; outerCircle.style.bottom = '5%'; outerCircle.style.left = '5%'; outerCircle.style.height = '50px'; outerCircle.style.width = '50px'; outerCircle.style.borderRadius = '50%'; let inner = document.createElement('p') inner.style.display = 'flex'; inner.style.alignItems = 'center'; outerCircle.append(inner); document.body.appendChild(outerCircle);`;

  Users.findOne({ _id: userId }, async (err, user) => {
    if (err) {
      return res.status(404).json({ error: "Error finding users." });
    } else if (!user) {
      return res.status(404).json({ error: "User record not found." });
    }

    if (!FEATURES.includes(feature)) {
      return res.status(400).json({ error: "Invalid Feature" });
    }

    let Domain = user?.Sites?.find(
      (site) => site.domainName === domainName && site._id == siteKey
    );
    if (typeof Domain !== "undefined") {
      let index = Domain.Feature.indexOf(feature);
      if (Domain.isActive[index] && Domain.subscriptionId[index] !== "") {
        return res.status(200).json({ isActive: true, script: script });
      } else if (!Domain.isActive[index]) {
        return res.status(400).json({ isActive: false });
      } else {
        return res.status(400).json({ isActive: false });
      }
    } else {
      return res
        .status(400)
        .json({ error: "In valid domain", isActive: false });
    }
  });
};

exports.cancelSubscription = async (req, res) => {
  const { email, domain, feature, paymentMethod } = req.body;
  try {
    Users.findOne({ Email: email }, async (err, user) => {
      if (err) {
        return res.status(404).json({ error: "Error finding users." });
      } else if (!user) {
        return res.status(404).json({ error: "User record not found." });
      }
      let result = user?.Sites?.find((site) => site.domainName == domain);
      if (typeof result !== "undefined") {
        let index = result.Feature.indexOf(feature);
        if (!PAYMENT_METHODS.includes(paymentMethod)) {
          return res
            .status(400)
            .json({
              error: `Your payment method not available! Try selecting ${PAYMENT_METHODS}`,
            });
        }
        if (result.subscriptionId[index] != "") {
          if (result.paymentMethod[index] != paymentMethod) {
            return res
              .status(400)
              .json({
                error: "This payment method does not matches with this feature",
              });
          }
          const token = await generatePaypalToken();
          if (token) {
            await axios({
              method: "POST",
              url: `${process.env.BASE_URL_PAYPAL_SUB}/${result.subscriptionId[index]}/cancel`,
              headers: {
                authorization: `Bearer ${token}`,
              },
            })
              .then(async (res) => {
                result.isActive[index] = false;
                result.subscriptionId[index] = "";
                await user
                  .save()
                  .then(() => {
                    res
                      .status(200)
                      .json({ message: "Subscription canceled successfully" });
                  })
                  .catch((err) => {
                    res
                      .status(400)
                      .json({ error: "Error in updating database" });
                  });
              })
              .catch((err) => {
                return res
                  .status(400)
                  .json({ error: "Error in canceling subcription" });
              });
          } else {
            return res.status(400).json({ error: "Error in generating token" });
          }
        } else {
          return res
            .status(400)
            .json({
              error: "Already deactivate! Please subscribe to a plan.",
              isActive: false,
            });
        }
      } else {
        return res.status(400).json({ error: `In valid domain ${domain}` });
      }
    });
  } catch (e) {
    return res.status(404).send(e);
  }
};

exports.activateScript = async (req, res) => {
  const { email, domain, feature, paymentMethod } = req.body;
  try {
    Users.findOne({ Email: email }, async (err, user) => {
      if (err) {
        return res.status(404).json({ error: "Error finding users." });
      } else if (!user) {
        return res.status(404).json({ error: "User record not found." });
      }
      let result = user?.Sites?.find((site) => site.domainName == domain);
      if (typeof result !== "undefined") {
        let index = result.Feature.indexOf(feature);
        if (!PAYMENT_METHODS.includes(paymentMethod)) {
          return res
            .status(400)
            .json({
              error: `Your payment method not available! Try selecting ${PAYMENT_METHODS}`,
            });
        }
        if (result.subscriptionId[index] != "") {
          if (result.paymentMethod[index] != paymentMethod) {
            return res
              .status(400)
              .json({
                error: "This payment method does not matches with this feature",
              });
          }
          const token = await generatePaypalToken();
          if (token) {
            await axios({
              method: "POST",
              url: `${process.env.BASE_URL_PAYPAL_SUB}/${result.subscriptionId[index]}/activate`,
              data: { reason: "Re-Activating Script " },
              headers: {
                "Content-Type": "application/json",
                Authorization: `Bearer ${token}`,
              },
            })
              .then(async () => {
                result.isActive[index] = true;
                await user
                  .save()
                  .then(() => {
                    res
                      .status(200)
                      .json({ message: "Subscription Activated!" });
                  })
                  .catch((err) => {
                    res
                      .status(400)
                      .json({ error: "Error in updating database" });
                  });
              })
              .catch((err) => {
                return res
                  .status(400)
                  .json({ error: "Error in activating subcription" });
              });
          } else {
            return res.status(400).json({ error: "Error in generating token" });
          }
        } else {
          return res
            .status(400)
            .json({
              error: "Unable to deactivate! Please subscribe to a plan first.",
              isActive: false,
            });
        }
      } else {
        return res.status(400).json({ error: `In valid domain ${domain}` });
      }
    });
  } catch (e) {
    return res.status(404).send(e);
  }
};

exports.deActivateScript = async (req, res) => {
  const { email, domain, feature, paymentMethod } = req.body;
  try {
    Users.findOne({ Email: email }, async (err, user) => {
      if (err) {
        return res.status(404).json({ error: "Error finding users." });
      } else if (!user) {
        return res.status(404).json({ error: "User record not found." });
      }
      let result = user?.Sites?.find((site) => site.domainName == domain);
      if (typeof result !== "undefined") {
        let index = result.Feature.indexOf(feature);
        if (!PAYMENT_METHODS.includes(paymentMethod)) {
          return res
            .status(400)
            .json({
              error: `Your payment method not available! Try selecting ${PAYMENT_METHODS}`,
            });
        }
        if (result.subscriptionId[index] != "") {
          if (result.paymentMethod[index] != paymentMethod) {
            return res
              .status(400)
              .json({
                error: "This payment method does not matches with this feature",
              });
          }
          const token = await generatePaypalToken();
          if (token) {
            await axios({
              method: "POST",
              url: `${process.env.BASE_URL_PAYPAL_SUB}/${result.subscriptionId[index]}/suspend`,
              data: { reason: "De - Activating " },
              headers: {
                "Content-Type": "application/json",
                Authorization: `Bearer ${token}`,
              },
            })
              .then(async () => {
                result.isActive[index] = false;
                await user
                  .save()
                  .then(() => {
                    res
                      .status(200)
                      .json({ message: "Subscription Deactivated!" });
                  })
                  .catch((err) => {
                    res
                      .status(400)
                      .json({ error: "Error in updating database" });
                  });
              })
              .catch((err) => {
                return res
                  .status(400)
                  .json({ error: "Error in deActivating Script" });
              });
          } else {
            return res.status(400).json({ error: "Error in generating token" });
          }
        } else {
          return res
            .status(400)
            .json({
              error: "Already deactivate! Please subscribe to a plan.",
              isActive: false,
            });
        }
      } else {
        return res.status(400).json({ error: `In valid domain ${domain}` });
      }
    });
  } catch (e) {
    return res.status(404).send(e);
  }
};

exports.activateFreeScript = async (req, res) => {
  const { email, domain, feature } = req.body;
  await freeScriptActiveOrDeactive(email, domain, feature, true)
    .then(data => {
      return res.status(200).json(data);
    })
    .catch((error) => {
      return res.status(400).json(error);
    });
};

exports.deActivateFreeScript = async (req, res) => {
  const { email, domain, feature } = req.body;
  await freeScriptActiveOrDeactive(email, domain, feature, false)
    .then(data => {
      return res.status(200).json(data);
    })
    .catch((error) => {
      return res.status(400).json(error);
    });
};

const freeScriptActiveOrDeactive = async (email, domain, feature, isActive) => {
  return new Promise ((resolve, reject) => {
    try {
      Users.findOne({ Email: email }, async (err, user) => {
        if (err) {
          reject({ error: "Error finding users." });
        } else if (!user) {
          reject({ error: "User record not found." });
        }
        let result = user?.Sites?.find((site) => site.domainName == domain);
        if (typeof result !== "undefined") {
          if (!FEATURES.includes(feature)) {
            reject({ error:`Requested feature '${feature}' not available` })
          }
          let index = result.Feature.indexOf(feature);
          if (result.paymentMethod[index] !== 'NULL' ||
            result.subscriptionId[index] !== process.env.ADMIN_SUBSCRIPTION_ID
          ) {
            reject({ error: `Your subscription is not free.` });
          } else {
            result.isActive[index] = isActive;
            await user
              .save()
              .then(() => {
                resolve({ message: (isActive ? "Subscription Activated!" : "Subscription Deactivated!") });
              })
              .catch((err) => {
                reject({ error: "Error in updating database" });
              });
          }
        } else {
          reject({ error: `In valid domain ${domain}` });
        }
      });
    } catch (e) {
      reject({ error: e });
    }
  });
}