const stripe = require("stripe")(process.env.STRIPE_KEY);
const Users = require("../models/user");
const { FEATURES, PAYMENT_METHODS } = require('../constants/app.constants');
const { generatePaypalToken } = require("../config/paypalHelper");
const { default: axios } = require("axios");

exports.createSession = async (req, res) => {
  try {
    const { email, domainName, feature, subscriptionId, paymentMethod } = req.body;
    if(!FEATURES.includes(feature)) {
      return res.status(400).json({error: `Requested feature not available! Try using ${FEATURES}`});
    }
    if(!PAYMENT_METHODS.includes(paymentMethod)) {
      return res.status(400).json({error: `Requested payment method not available! Try using ${PAYMENT_METHODS}`});
    }
    Users.findOne({ Email: email }, async (err, user) => {
      if (err) {
        return res.status(404).json({ error: 'Error finding users.' });
      } else if (!user) {
        return res.status(404).json({ error: 'User record not found.' });
      }
      let result = user?.Sites?.find((site) => site.domainName == domainName);
      if(typeof(result) !== 'undefined'){
        let index = result?.Feature?.indexOf(feature)
        result.subscriptionId[index] = subscriptionId; // Storing Subscription ID with specific domain
        result.paymentMethod[index] = paymentMethod; // Storing Payment Method with specific domain
        result.isActive[index] = true;
        await user
          .save()
          .then(() => {
            res.status(200).json({message: `Subscription stored against domain ${domainName}`});
          })
          .catch((err) => {
            res.status(400).json(e);
          });
      }
      else {
        return res.status(400).json({error: `Domain ${domainName} does not exist, Please register domain first`});
      }
    });
  } catch (e) {
    return res.status(400).json(e);
  }
};

const checkout = (email,domain,feature) => {
  console.log("Feature ", feature)

  Users.findOne({ Email: email }, async (err, user) => {
    if (err) {
      console.log("Error finding user" );
    } else if (!user) {
      console.log("User not found" );
    }
    const subscriptions = await stripe.subscriptions.list(
      {
        customer: user.userStripeId,
        status: "all",
        limit: 1,
        expand: ["data.default_payment_method"],
      },
      {
        apiKey: process.env.STRIPE_SECRET_KEY,
      }
    );
    let result = user?.Sites?.find((site) => site.domainName == domain);
    if(typeof(result) !== 'undefined'){
      let index = result?.Feature?.indexOf(feature)
      result.stripeSubscriptionId[index] = subscriptions.data[0].id; // Storing Subscription ID with specific domain
      result.isActive[index] = true;
      await user
        .save()
        .then(() => {
          console.log("User Subscribed Successfully")
        })
        .catch((err) => {
          console.log(err)
        });
    }
    else {
      console.log("Requested feature not found")
    }
  });
};

exports.plans = async (req, res) => {
  return res.status(503).json({message: 'Stripe Removed! No response'})
 // Return available plans
  const plans = await stripe.prices.list({
      apiKey: process.env.STRIPE_KEY
  });
    let response = plans.data.map(plan => {return({id: plan.id, name: plan.nickname, price: plan.unit_amount/100, interval: plan.recurring.interval})})
  return res.json(response)

  // Send List of subscriptions
  // const subscriptions = await stripe.subscriptions.list(
  //   {
  //     customer: "cus_LnP1yXAA5XZ1wQ", // user.userStripeId,
  //     status: "all",
  //     limit: 1,
  //     expand: ["data.default_payment_method"],
  //   },
  //   {
  //     apiKey: process.env.STRIPE_SECRET_KEY,
  //   }
  // );
  // res.json(subscriptions);

  // Delete specific subscription
  // stripe.subscriptions.del('sub_49ty4767H20z6a');
};

exports.createStripeSession = async (req, res) => {
  try {
    const {email, priceId, domainName, feature} = req.body
    const user = await Users.findOne({ Email: email });
  //  console.log("User ", user);
    const session = await stripe.checkout.sessions.create(
      {
        mode: "subscription",
        payment_method_types: ["card"],
        line_items: [
          {
            price: priceId,
            quantity: 1,
          },
        ],
        success_url: "http://plugin-app.herokuapp.com/success",
        cancel_url: "http://plugin-app.herokuapp.com/failure",
        customer: user.userStripeId,
        metadata: {
          domainName: domainName,
          feature: feature,
        },
      },
      {
        apiKey: process.env.STRIPE_SECRET_KEY,
      }
    );

    res.status(200).json(session.url);
  } catch (e) {
    res.status(400).json(e);
  }
};

exports.webhookPaypal = async (req, res, next) => {
  console.log("webhook is called");
  const notificationData = req.body;
  try {
        const token = await generatePaypalToken();
        if(token){
            const headers = req.headers;
            const transmissionId = headers['paypal-transmission-id']
            const transmissionSignature = headers['paypal-transmission-sig']
            const transmissionTime = headers['paypal-transmission-time']
            const authAlgo = headers['paypal-auth-algo']
            const paypalCertUrl = headers['paypal-cert-url']
            await axios({
                method:'POST',
                url:`${process.env.BASE_URL_PAYPAL_WEBHOOK}/verify-webhook-signature`,
                data:{reason:'Verify webhook signature'},
                headers: {
                    "Content-Type": 'application/json',
                    "Authorization": `Bearer ${token}`
                },
                data: {
                    "webhook_id": process.env.PAYPAL_WEBHOOK_ID,
                    "transmission_id": transmissionId,
                    "transmission_time": transmissionTime,
                    "cert_url": paypalCertUrl,
                    "auth_algo": authAlgo,
                    "transmission_sig": transmissionSignature,
                    "webhook_event": notificationData
                }
            })
            .then(async (result) => {
                console.log('Event Type', notificationData.event_type)
                switch (notificationData.event_type) {
                  case "PAYMENT.SALE.COMPLETED":
                    const successSubID = notificationData.resource.id;
                    const successEmailID = notificationData.resource.custom_id;
                    const successCustID = notificationData.resource.subscriber.payer_id;
                    await updateSuccessSub(successEmailID,successSubID)
                    break;
              
                  case "BILLING.SUBSCRIPTION.PAYMENT.FAILED":
                    const subscriptionID = notificationData.resource.id;
                    const emailID = notificationData.resource.custom_id;
                    const customerID = notificationData.resource.subscriber.payer_id;
                    console.log("Failure Sub ID ",subscriptionID," Email ID ",emailID)
                    if (emailID) {
                      await updateSub(emailID,subscriptionID,false);
                    } else {
                      console.log("no customer found");
                    }
                    break;
              
                  case "BILLING.SUBSCRIPTION.CANCELLED":
                    const subID = notificationData.resource.id;
                    const mailID = notificationData.resource.custom_id;
                    const custID = notificationData.resource.subscriber.payer_id;
                    console.log("Delete Sub ID ",subID," Mail ID ",mailID)
                    if (mailID) {
                      await updateSub(mailID,subID,true);
                    } else {
                      console.log("no customer found");
                    }
              
                    break;

                  // case "BILLING.SUBSCRIPTION.SUSPENDED":
                  //   const pausedSubID = notificationData.resource.id;
                  //   const pausedEmailID = notificationData.resource.custom_id;
                  //   const pausedCustomerID = notificationData.resource.subscriber.payer_id;
                  //   console.log("Failure Sub ID ",pausedSubID," Email ID ",pausedEmailID)
                  //   if (pausedEmailID) {
                  //     await updateSub(pausedEmailID,pausedSubID,false);
                  //   } else {
                  //     console.log("no customer found");
                  //   }
                  //   break;

                  // case "BILLING.SUBSCRIPTION.ACTIVATED":
                  //     // const activateSubID = notificationData.resource.id;
                  //     // const activateEmailID = notificationData.resource.custom_id;
                  //     // const activateCustID = notificationData.resource.subscriber.payer_id;
                  //     // await updateSuccessSub(activateEmailID,activateSubID)
                  //     break;
                  
                  // case "BILLING.SUBSCRIPTION.RE-ACTIVATED":
                  //   console.log('re-activated webhook called')
                  //  break;

                   
                  //  case "BILLING.SUBSCRIPTION.UPDATED":
                  //   console.log('updated webhook called')
                  //  break;
              
                  default:
                    console.log(`Unhandled event type ${notificationData.event_type}`);
                }
            })
            .catch(err => {
                console.log(err.response.data.details)
            })
        }   
        else{
            console.log("Error in generating token")
        }
  } catch (e) {
      console.log(e)
  }
};

exports.webhookCheckout = async (request, response, next) => {
  console.log("webhook is called");
  const signature = request.headers["stripe-signature"];

  let event;
  try {
    event = stripe.webhooks.constructEvent(
      request.rawBody,
      signature,
      "whsec_cb7Ntssrr5wfE5DJUdOjjHSCCGlgx4ab"
    );
  } catch (err) {
    return response.status(400).send(`Webhook error: ${err.message}`);
  }
  console.log("event.type ", event.type);
  switch (event.type) {
    case "checkout.session.completed":
      const session = event.data.object;
      const DomainName = session.metadata.domainName;
      const feature = session.metadata.feature;
      const Email = session.customer_details.email;
      console.log("Session Completed")
      await checkout(Email,DomainName,feature);

      break;

    // case "payment_intent.succeeded":
    //   const paymentIntent = event.data.object;
    //   const price = paymentIntent.amount_received;
    //   const userId = paymentIntent["customer"];
    //   console.log("Succeeded ",paymentIntent)

    //   if (userId) {
    //     const customer = await stripe.customers.retrieve(userId);
    //     //  createCustomerPlain(customer, price, true);
    //   } else {
    //     console.log("no customer found");
    //   }

    //   break;

    case "invoice.payment_succeeded":
      const successPaymentIntent = event.data.object;
      const successSubID = successPaymentIntent.subscription;
      const successCustID = successPaymentIntent.customer
      await updateSuccessSub(successCustID,successSubID)
      break;

    case "invoice.payment_failed":
      const paymentIntent = event.data.object;
      const subscriptionID = paymentIntent.subscription;
      const customerID = paymentIntent.customer
      console.log("Failure Sub ID ",subscriptionID," Cust ID ",customerID)
      if (customerID) {
        await updateSub(customerID,subscriptionID,false);
      } else {
        console.log("no customer found");
      }
      break;

    // case "payment_intent.payment_failed":
    //   const paymentIntent2 = event.data.object;
    //   const message = paymentIntent2.last_payment_error && paymentIntent2.last_payment_error.message;
    //   console.log('Failed:', paymentIntent2.id, message);
    //   break;

    case "customer.subscription.deleted":
      const subIntent = event.data.object;
      const subID = subIntent.id;
      const custID = subIntent.customer;
      console.log("Delete Sub ID ",subID," Cust ID ",custID)
      if (custID) {
        await updateSub(custID,subID,true);
      } else {
        console.log("no customer found");
      }

      break;

    default:
      console.log(`Unhandled event type ${event.type}`);
  }

  response.json({ received: true });
};

const updateSub = (emailID,subID,isDelete) =>{
  // Need paypal id in custId
  Users.findOne({ Email: emailID }, async (err, user) => {
    if (err) {
      console.log("Error finding user" );
    } else if (!user) {
      console.log("User not found" );
    }
    //let subscription = user?.Sites?.find((site) => site.stripeSubscriptionId === subID);
    let subscription = user?.Sites?.find((site) => site.subscriptionId.find((s) => s === subID) );

    if(typeof(subscription) !== 'undefined'){    
      let index = subscription.subscriptionId.indexOf(subID)
      subscription.isActive[index] = false;
      if(isDelete)
      {
        subscription.subscriptionId[index] = '';
      }
      await user.save().then(() => console.log("Subscription updated"))
    }
    else {
        console.log("Subscription not found")
    }
})
}

const updateSuccessSub = (emailID,subID) =>{
  // Need paypal id in custId
  Users.findOne({ Email: emailID }, async (err, user) => {
    if (err) {
      console.log("Error finding user" );
    } else if (!user) {
      console.log("User not found" );
    }
    //let subscription = user.Sites.find((site) => site.stripeSubscriptionId === subID);
    let subscription = user?.Sites?.find((site) => site.subscriptionId.find((s) => s === subID) );

    if(typeof(subscription) !== 'undefined'){
      let index = subscription.subscriptionId.indexOf(subID)
      if(!subscription.isActive[index])
      {
        subscription.isActive[index] = true;
        await user.save().then(() => console.log("Subscription updated"))
      }
      else{
        console.log("Subscription already active. No updation required")
      }
    }
    else {
        console.log("Subscription not found")
    }
})
}

//getting session details agains the webhook id

// exports.createSessionWithTrial = async(req,res) => {
  //     try {
  //         const user = await Users.findOne({Email: req.body.email})
  //         console.log("User ", user);
  //         const session = await stripe.subscriptions.create({
  //             items : [
  //                 {
  //                     price: req.body.priceId,
  //                     quantity: 1,
  //                 }
  //             ],
  //             customer: user.userStripeId,
  //             trial_period_days: 7,
  //         },
  //         {
  //              apiKey: process.env.STRIPE_SECRET_KEY,
  //         })
  //         const subscriptions = await stripe.subscriptions.list(
  //             {
  //               customer: user.userStripeId,
  //               status: "all",
  //               expand: ["data.default_payment_method"],
  //             },
  //             {
  //               apiKey: process.env.STRIPE_SECRET_KEY,
  //             }
  //         );
  //           let ids = subscriptions.data.map(d => d.id)
  //           let url = session.url
  //           console.log(session)
  //           res.send({ids,url})
  //        // res.status(200).json(session.url)
  //     }
  //    catch(e){
  //     res.status(400).json(e)
  //    }
  // }

  //HXNJN3836DN8E