const EventsModel = require("../models/events");
const UserModel = require("../models/user");
const { blobServiceClient } = require("../config/blobStorageHelper.js");

// [Node.js only] A helper method used to read a Node.js readable stream into a Buffer
async function streamToBuffer(readableStream) {
  return new Promise((resolve, reject) => {
    const chunks = [];
    readableStream.on("data", (data) => {
      chunks.push(data instanceof Buffer ? data : Buffer.from(data));
    });
    readableStream.on("end", () => {
      resolve(Buffer.concat(chunks));
    });
    readableStream.on("error", reject);
  });
}

async function createBlob(sessionEvents) {
  return new Promise(async (resolve, reject) => {
    try {
      const containerName = "eventscontainer";
      const containerClient = await blobServiceClient.getContainerClient(
        containerName
      );
      const content = JSON.stringify(sessionEvents);
      const blobName = "newblob" + new Date().getTime();
      const blockBlobClient = containerClient.getBlockBlobClient(blobName);
      const uploadBlobResponse = await blockBlobClient.upload(
        content,
        content.length
      );
      console.log(
        `Upload block blob ${blobName} successfully`,
        uploadBlobResponse.requestId
      );
      resolve(blobName);
    } catch (err) {
      reject(err);
    }
  });
}

async function getBlob(blobName) {
  return new Promise(async (resolve, reject) => {
    try {
      const containerName = "eventscontainer";
      const containerClient = await blobServiceClient.getContainerClient(
        containerName
      );
      const blobClient = containerClient.getBlobClient(blobName);
      // Get blob content from position 0 to the end
      // In Node.js, get downloaded data by accessing downloadBlockBlobResponse.readableStreamBody
      const downloadBlockBlobResponse = await blobClient.download();
      const downloaded = (
        await streamToBuffer(downloadBlockBlobResponse.readableStreamBody)
      ).toString();
      resolve(JSON.parse(downloaded));
    } catch (err) {
      reject(err);
    }
  });
}

exports.addEvents = async (req, res) => {
  try {
    const { userId, siteKey, events } = req.body;
    const ip = req.headers["x-forwarded-for"] || req.connection.remoteAddress;
    UserModel.findOne({ _id: userId }, async (err, user) => {
      if (err) {
        console.log("Error ", err);
        return res.status(400).json({ error: `Error: ${err.message}` });
      } else if (!user) {
        return res.status(400).json({
          error: "Email not Registered. Please Sign Up!",
        });
      } else {
        let result = user?.Sites?.find((site) => site._id == siteKey);
        if (result) {
          if (
            !result.Feature.includes("PLUGIN_ANALYTICS_COMBO") &&
            !result.Feature.includes("ALL_FEATURES")
          ) {
            return res.status(400).json({
              error: "Sorry! can't find this feature on your site.",
            });
          }
          await EventsModel.findOne({ _userId: userId, _siteId: siteKey }).exec(
            async (err, event) => {
              if (err) {
                res.status(400).json({ error: `Error: ${err.message}` });
              } else if (event) {
                //   event.events = event.events.concat(events)

                createBlob(events?.sessionEvents)
                  .then((blobName) => {
                    console.log("blob is created", blobName);
                    events.sessionEvents = blobName;
                    let updateEvent = {
                      ...events,
                      ipAddress: ip,
                    };
                    event.events.push(updateEvent);
                    event.save((err, data) => {
                      if (err) {
                        console.log("Error in saving events: ", err.message);
                        res.status(400).json({
                          error: `Error in saving events ${err.message}`,
                        });
                      } else if (data) {
                        res
                          .status(200)
                          .json({ message: `Events saved successfully` });
                      }
                    });
                  })
                  .catch((err) => {
                    console.log("error in creating blob", err);
                    res
                      .status(400)
                      .json({ error: `Error in creating blob ${err.message}` });
                  });
              } else {
                console.log("new");

                createBlob(events?.sessionEvents)
                  .then((blobName) => {
                    console.log("blob is created", blobName);
                    events.sessionEvents = blobName;
                    let updateEvent = {
                      ...events,
                      ipAddress: ip,
                    };
                    let newEvent = new EventsModel({
                      _userId: userId,
                      _siteId: siteKey,
                      events: updateEvent,
                    });
                    newEvent.save((err, data) => {
                      if (err) {
                        console.log("Error in saving events: ", err.message);
                        res.status(400).json({
                          error: `Error in saving events ${err.message}`,
                        });
                      } else if (data) {
                        res
                          .status(200)
                          .json({ message: `Events saved successfully` });
                      }
                    });
                  })
                  .catch((err) => {
                    console.log("error in creating blob", err);
                    res
                      .status(400)
                      .json({ error: `Error in creating blob ${err.message}` });
                  });
              }
            }
          );
        } else {
          return res.status(400).json({
            error: `User with this site key ${siteKey} does not exit.`,
          });
        }
      }
    });
  } catch (e) {
    res.status(400).json({ error: `Error: ${e.message}` });
  }
};

exports.getEvents = async (req, res) => {
  try {
    const { email, domainName } = req.body;
    UserModel.findOne({ Email: email }, async (err, user) => {
      if (err) {
        console.log("Error ", err);
        return res.status(400).json({ error: `Error: ${err.message}` });
      } else if (!user) {
        return res.status(400).json({
          error: "Email not Registered. Please Sign Up!",
        });
      } else {
        let result = user?.Sites?.find((site) => site.domainName == domainName);
        if (result) {
          if (
            !result.Feature.includes("PLUGIN_ANALYTICS_COMBO") &&
            !result.Feature.includes("ALL_FEATURES")
          ) {
            console.log(result.Feature)
            return res.status(400).json({
              error: "Unable to fetch events, can't find this feature on your site.",
            });
          }
          await EventsModel.findOne({
            _userId: user._id,
            _siteId: result._id,
          }).exec(async (err, event) => {
            if (err) {
              return res.status(400).json({ error: `Error: ${err.message}` });
            } else if (!event) {
              return res.status(500).json({ error: "No events found" });
            } else {
              res.status(200).json({ events: event.events });
            }
          });
        } else {
          return res
            .status(400)
            .json({ error: `Domain: ${domainName} does not exist` });
        }
      }
    });
  } catch (e) {
    res.status(400).json({ error: `Error: ${e.message}` });
  }
};

exports.getBlobData = async (req, res) => {
  const blobName = req?.params?.blobName;
  getBlob(blobName)
    .then((downloaded) => {
      // console.log("blob is received", downloaded);
      res.status(200).json({ sessionEvents: downloaded });
    })
    .catch((err) => {
      console.log("error in creating blob", err);
      res.status(400).json({ error: `Error in getting blob ${err.message}` });
    });
};
