const axios = require('axios');
const qs = require('qs');

module.exports.generatePaypalToken = () => {
    return new Promise(async(resolve,reject)=>{
        try {
            console.log("In PAYPAL Helper")
            const token = await axios({
                method:'POST',
                url:'https://api-m.sandbox.paypal.com/v1/oauth2/token',
                headers: { 'content-type': 'application/x-www-form-urlencoded' },
                data: qs.stringify({grant_type: 'client_credentials' }),
                auth: {
                    username: process.env.PAYPAL_USERNAME,
                    password: process.env.PAYPAL_PASSWORD
                }
            }).then(res => res.data.access_token)
            .catch(err => {
                console.log("Error in generating paypal token", err);
                resolve(false);
            })
            resolve(token);
        } catch(e) {
            resolve(false);
        }
    })
}